#include <maps/wikimap/mapspro/services/mrc/libs/db/include/feature.h>

#include <functional>
#include <memory>

namespace maps::mrc::feature_publisher {

using LoadImageFn = std::function<common::Blob(const db::Feature&)>;

struct ICameraDeviationClassifier {
    virtual ~ICameraDeviationClassifier() = default;

    virtual db::CameraDeviation evalForPassage(db::Features::iterator first,
                                               db::Features::iterator last,
                                               LoadImageFn) = 0;
};

using ICameraDeviationClassifierHolder =
    std::unique_ptr<ICameraDeviationClassifier>;

struct CameraDeviationClassifier : ICameraDeviationClassifier {
    db::CameraDeviation evalForPassage(db::Features::iterator first,
                                       db::Features::iterator last,
                                       LoadImageFn) override;
};

}  // namespace maps::mrc::feature_publisher
