#include "counter.h"

#include <maps/libs/chrono/include/days.h>

namespace maps::mrc::feedback_stat {

TTimelineBySource count(const social::FeedbackTasks& feedbackTasks,
                        const TIdSet& committedFeedbackIds,
                        const TIdToSignalMap& feedbackIdToSignalMap)
{
    TTimelineBySource result;
    for (const auto& feedbackTask : feedbackTasks) {
        bool committed = committedFeedbackIds.count(feedbackTask.id);
        auto source = feedbackIdToSignalMap.at(feedbackTask.id).source;
        auto day = std::chrono::floor<chrono::Days>(feedbackTask.createdAt);
        auto type = feedbackTask.type;
        if (feedbackTask.verdict) {
            switch (*feedbackTask.verdict) {
                case wiki::social::feedback::Verdict::Rejected:
                    ++result[source][day][type].rejected;
                    break;
                case wiki::social::feedback::Verdict::Accepted:
                    if (committed) {
                        ++result[source][day][type].committed;
                    }
                    else {
                        ++result[source][day][type].accepted;
                    }
                    break;
            }
        }
        else {
            ++result[source][day][type].waiting;
        }
    }
    return result;
}

Counter sum(const TTimelineBySource& timelineBySource)
{
    Counter result{};
    for (const auto& [source, timeline] : timelineBySource) {
        for (const auto& [day, counterByType] : timeline) {
            for (const auto& [feedbackType, counter] : counterByType) {
                result += counter;
            }
        }
    }
    return result;
}

}  // namespace maps::mrc::feedback_stat
