#pragma once

#include "social.h"

#include <maps/libs/chrono/include/time_point.h>
#include <maps/libs/introspection/include/comparison.h>

#include <map>
#include <ostream>

namespace maps::mrc::feedback_stat {

struct Counter {
    size_t waiting;
    size_t rejected;
    size_t accepted;
    size_t committed;

    auto introspect() const
    {
        return std::tie(waiting, rejected, accepted, committed);
    }

    Counter& operator+=(const Counter& that)
    {
        this->waiting += that.waiting;
        this->rejected += that.rejected;
        this->accepted += that.accepted;
        this->committed += that.committed;
        return *this;
    }

    friend std::ostream& operator<<(std::ostream& dest, const Counter& src)
    {
        dest << "waiting=" << src.waiting << "; rejected=" << src.rejected
             << "; accepted=" << src.accepted
             << "; committed=" << src.committed;
        return dest;
    }
};

using maps::introspection::operator==;

using TCounterByType = std::map<wiki::social::feedback::Type, Counter>;
using TTimeline = std::map<chrono::TimePoint, TCounterByType>;
using TTimelineBySource = std::map<Source, TTimeline>;

TTimelineBySource count(const social::FeedbackTasks&,
                        const TIdSet& committedFeedbackIds,
                        const TIdToSignalMap& feedbackIdToSignalMap);

Counter sum(const TTimelineBySource& timelineBySource);

}  // namespace maps::mrc::feedback_stat
