#pragma once

#include "tools.h"

#include <maps/libs/pgpool/include/pgpool3.h>
#include <yandex/maps/wiki/social/feedback/enums.h>

namespace maps::mrc::feedback_stat::social {

/// subset of wiki::social::feedback::Task for unit-test
struct FeedbackTask {
    TId id;
    chrono::TimePoint createdAt;
    wiki::social::feedback::Type type;
    std::optional<wiki::social::feedback::Verdict> verdict;
};

using FeedbackTasks = std::vector<FeedbackTask>;

FeedbackTasks loadFeedbackTasks(pgpool3::Pool&, const TIdSet& feedbackIds);

TIdSet loadCommittedFeedbackIds(pgpool3::Pool&, const FeedbackTasks&);

}  // namespace maps::mrc::feedback_stat::social
