#include "tools.h"

#include <maps/libs/enum_io/include/enum_io.h>

using namespace std::string_view_literals;

namespace maps::mrc::feedback_stat {

constexpr enum_io::Representations<Source> SOURCE_STRINGS{
    {Source::Agents, "agents"sv},
    {Source::Drive, "drive"sv},
    {Source::Other, "other"sv},
    {Source::Panorama, "panorama"sv},
    {Source::Rides, "rides"sv},
    {Source::Video, "video"sv},
    {Source::Walks, "walks"sv},
    {Source::Tehran, "tehran"sv},
    {Source::PedestrianTask, "pedestrian_task"sv},
    {Source::BackofficeObject, "backoffice_object"sv},
    {Source::BackofficePhoto, "backoffice_photo"sv},
    {Source::AltayPedestrians, "altay_pedestrians"sv},
    {Source::YangPedestrians, "yang_pedestrians"sv},
    {Source::NexarDashcams, "nexar_dashcams"sv},
    {Source::TaxiSignalQ2, "taxi_signal_q2"sv},
    {Source::TolokaPedestrians, "toloka_pedestrians"sv},
};

DEFINE_ENUM_IO(Source, SOURCE_STRINGS);

Source convertToSource(db::Dataset dataset)
{
    switch(dataset) {
        case db::Dataset::Agents: return Source::Agents;;
        case db::Dataset::Drive: return Source::Drive;
        case db::Dataset::Rides: return Source::Rides;
        case db::Dataset::Video: return Source::Video;
        case db::Dataset::Walks: return Source::Walks;
        case db::Dataset::Tehran: return Source::Tehran;
        case db::Dataset::PedestrianTask: return Source::PedestrianTask;
        case db::Dataset::BackofficeObject: return Source::BackofficeObject;
        case db::Dataset::BackofficePhoto: return Source::BackofficePhoto;
        case db::Dataset::AltayPedestrians: return Source::AltayPedestrians;
        case db::Dataset::YangPedestrians: return Source::YangPedestrians;
        case db::Dataset::NexarDashcams: return Source::NexarDashcams;
        case db::Dataset::TaxiSignalQ2: return Source::TaxiSignalQ2;
        case db::Dataset::TolokaPedestrians: return Source::TolokaPedestrians;
        default: return Source::Other;
    }
}

}  // namespace maps::mrc::feedback_stat
