#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/common.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/dataset.h>

#include <maps/libs/enum_io/include/enum_io_fwd.h>
#include <maps/libs/chrono/include/time_point.h>
#include <maps/libs/introspection/include/comparison.h>
#include <maps/libs/pgpool/include/pgpool3.h>

#include <boost/range/adaptor/map.hpp>

#include <ostream>
#include <set>
#include <string>
#include <unordered_map>

namespace maps::mrc::feedback_stat {

const std::string APP_NAME = "feedback_stat";
const std::string LAST_RUN_TIME = APP_NAME + ".timestamp";
const size_t BATCH_SIZE = 50000;
const int MAX_THREADS = 6;

enum class Source {
    Agents,
    Drive,
    Other,
    Panorama,
    Rides,
    Video,
    Walks,
    Tehran,
    PedestrianTask,
    BackofficeObject,
    BackofficePhoto,
    AltayPedestrians,
    YangPedestrians,
    NexarDashcams,
    TaxiSignalQ2,
    TolokaPedestrians,
};

DECLARE_ENUM_IO(Source);

/// signal examples: db::Feature, db::Panorama
struct Signal {
    chrono::TimePoint createdAt;
    Source source;

    auto introspect() const { return std::tie(createdAt, source); }

    friend std::ostream& operator<<(std::ostream& dest, const Signal& src)
    {
        dest << "createdAt=" << chrono::formatSqlDateTime(src.createdAt)
             << "; source=" << src.source;
        return dest;
    }
};

using maps::introspection::operator<;
using maps::introspection::operator==;

using TId = db::TId;
using TIdSet = std::set<TId>;
using TIdMap = std::unordered_map<TId, TId>;
using TIdMultiMap = std::unordered_multimap<TId, TId>;
using TIdToSignalMap = std::unordered_map<TId, Signal>;

template <class Map>
TIdSet mapKeys(const Map& map)
{
    auto rng = map | boost::adaptors::map_keys;
    return {rng.begin(), rng.end()};
}

template <class Map>
TIdSet mapValues(const Map& map)
{
    auto rng = map | boost::adaptors::map_values;
    return {rng.begin(), rng.end()};
}

Source convertToSource(db::Dataset dataset);

}  // namespace maps::mrc::feedback_stat
