#pragma once

#include "features_index.h"
#include "geobase.h"
#include "private_area.h"
#include "strings.h"
#include "yt_tables.h"

#include <maps/wikimap/mapspro/services/mrc/libs/config/include/config.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/feature.h>
#include <maps/wikimap/mapspro/services/mrc/libs/fb/include/coverage_rtree_reader.h>
#include <maps/wikimap/mapspro/services/mrc/libs/fb/include/coverage_rtree_reader.h>
#include <maps/wikimap/mapspro/services/mrc/libs/object/include/loader.h>

#include <maps/wikimap/mapspro/libs/common/include/yandex/maps/wiki/common/pgpool3_helpers.h>

#include <maps/libs/edge_persistent_index/include/persistent_index.h>
#include <maps/libs/road_graph/include/graph.h>
#include <maps/libs/succinct_rtree/include/rtree.h>
#include <maps/libs/geolib/include/point.h>

#include <mapreduce/yt/interface/client.h>

#include <string>
#include <tuple>

namespace maps::mrc::graph_coverage_export {


using LongEdgeIdToFeatureIdMap =
    std::unordered_map<road_graph::LongEdgeId, db::TIds>;

constexpr int THREADS_NUMBER = 20;

class ContextBase {
public:
    virtual const road_graph::Graph& graph() const = 0;
    virtual const succinct_rtree::Rtree& graphRTree() const = 0;
    virtual const road_graph::PersistentIndex& graphPersistentIndex() const = 0;
    virtual db::GraphType graphType() const = 0;
    virtual const geobase::GeobaseInterface& geobase() const = 0;
    virtual const PrivateAreaIndex& privateAreaIndex() const = 0;

    void processEdge(
        const maps::road_graph::EdgeData& edgeData,
        const geolib3::Polyline2& edgeGeometry,
        const db::Features& features,
        std::unordered_set<int32_t>& referencedGeoIds,
        NYT::TTableWriter<NYT::TNode>& writer) const;

    EdgeData makeEdgeData(
        const maps::road_graph::EdgeData& edgeData,
        const geolib3::Polyline2& edgeGeometry,
        const db::Features& features) const;

    std::vector<int32_t> evalGeoIds(const geolib3::Point2& geodeticPos) const;
};

class Context: public ContextBase {
public:
    Context(const std::string& mrcGraphPath,
            db::GraphType graphType,
            geobase::GeobasePtr geobasePtr,
            object::Loader& objectLoader);

    const road_graph::Graph& graph() const override;
    const succinct_rtree::Rtree& graphRTree() const override;
    const road_graph::PersistentIndex& graphPersistentIndex() const override;
    db::GraphType graphType() const override;
    const geobase::GeobaseInterface& geobase() const override;
    const PrivateAreaIndex& privateAreaIndex() const override;

private:
    road_graph::Graph graph_;
    succinct_rtree::Rtree graphRTree_;
    road_graph::PersistentIndex graphPersistentIndex_;
    db::GraphType graphType_;
    geobase::GeobasePtr geobasePtr_;
    PrivateAreaIndex privateAreaIndex_;

};

bool areCompatible(road_graph::AccessIdMask, db::GraphType);

} // namespace maps::mrc::graph_coverage_export


