#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/config/include/config.h>
#include <maps/wikimap/mapspro/services/mrc/libs/yt/include/common.h>
#include <maps/libs/geolib/include/bounding_box.h>

#include <optional>
#include <string>

namespace maps::mrc::graph_coverage_export {

void coverageExport(const common::Config& config,
                    const wiki::common::ExtendedXmlDoc& wikiConfig,
                    const std::string& mrcDatasetPath,
                    const std::string& mrcFeaturesSecretDatasetPath,
                    const std::string& geobasePath,
                    const std::string& geodataPatchYtDir,
                    const std::string& mrcRoadGraphPath,
                    const std::string& mrcPedestrianGraphPath,
                    const TString& ytDir,
                    const std::optional<geolib3::BoundingBox>& geoBbox);


/// Takes table with coverages timelifes at @param ytGraphCoveragePath
/// and converts them to a timeline-table with daily evaluations
/// of coverage value for each combination of aggregation
/// params (camera_deviation, dataset, ...)
void calculateGraphCoverageTimeline(
    NYT::IClientBase& ytClient,
    int32_t timelineEnd,
    const TString& ytGraphCoveragePath,
    const TString& ytOutputCoverageTimelinePath,
    std::optional<yt::PoolType> poolType = std::nullopt);

}  // namespace maps::mrc::graph_coverage_export
