#pragma once
#include <maps/wikimap/mapspro/services/mrc/libs/common/include/memory_map_option.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/feature.h>
#include <maps/wikimap/mapspro/services/mrc/libs/fb/include/features_reader.h>

#include <maps/libs/geolib/include/bounding_box.h>

#include <optional>
#include <string>

namespace maps::mrc::graph_coverage_export {

class FeaturesIndex {
public:
    FeaturesIndex(const std::string& mrcDatasetPath,
                  const std::string& mrcFeaturesSecretDatasetPath,
                  EMappingMode mappingMode = EMappingMode::Precharged)
        : defaultFeaturesReader_(mrcDatasetPath, mappingMode)
        , secretFeaturesReader_(mrcFeaturesSecretDatasetPath)
    {}

    db::Feature featureById(db::TId) const;

    db::TIds featureIds() const;
    db::TIds featureIdsInBbox(const geolib3::BoundingBox& bbox) const;

private:

    fb::FeaturesReader defaultFeaturesReader_;
    fb::FeaturesReader secretFeaturesReader_;
};


} // namespace maps::mrc::graph_coverage_export
