#pragma once

#include <maps/libs/geolib/include/polygon.h>
#include <maps/libs/geolib/include/polyline.h>
#include <maps/libs/geolib/include/static_geometry_searcher.h>

#include <maps/libs/pgpool/include/pgpool3.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/common.h>
#include <maps/wikimap/mapspro/services/mrc/libs/object/include/loader.h>

#include <vector>
#include <unordered_map>

namespace maps::mrc::graph_coverage_export {

class PrivateAreaIndex {
public:
    explicit PrivateAreaIndex(object::Loader& loader);

    bool isInPrivateArea(const geolib3::Polyline2& polyline, int fc) const;

private:

    struct PrivateAreaInfo {
        std::vector<geolib3::Polygon2> geodeticPolygons;
    };

    std::vector<geolib3::Polygon2> residentialRegions_;
    geolib3::StaticGeometrySearcher<geolib3::Polygon2, size_t> searcher_;
};

} // namespace maps::mrc::graph_coverage_export
