#include <maps/wikimap/mapspro/services/mrc/long_tasks/graph_coverage_export/lib/private_area.h>
#include <maps/wikimap/mapspro/services/mrc/libs/object/include/mock_loader.h>

#include <maps/libs/geolib/include/conversion.h>
#include <library/cpp/testing/gmock_in_unittest/gmock.h>
#include <library/cpp/testing/unittest/registar.h>

namespace maps::mrc::graph_coverage_export {
using namespace ::testing;

using geolib3::Polygon2;
using geolib3::Polyline2;
using geolib3::PointsVector;

Y_UNIT_TEST_SUITE(test_private_areas_index) {

Y_UNIT_TEST(test_exclusion_region) {
    object::MockLoader objectLoader;
    objectLoader.add(
         object::MrcRegions{
            object::MrcRegion(
                object::RevisionID{201, 1},
                geolib3::convertGeodeticToMercator(
                    Polygon2{PointsVector{{37.6, 55.6}, {37.7, 55.6},
                                        {37.7, 55.7}, {37.6, 55.6}}})
            ).type(object::MrcRegion::Type::Residential),
            object::MrcRegion(
                object::RevisionID{201, 1},
                geolib3::convertGeodeticToMercator(
                    Polygon2{PointsVector{{37.7, 55.7}, {37.7, 55.8},
                                        {37.8, 55.8}, {37.7, 55.7}}})
            ).type(object::MrcRegion::Type::Residential)
        }
    );

    PrivateAreaIndex index(objectLoader);

    EXPECT_FALSE(index.isInPrivateArea(
        Polyline2(PointsVector{{10, 20}, {10.1, 20.1}}), 7));

    EXPECT_FALSE(index.isInPrivateArea(
        Polyline2(PointsVector{{37.65, 55.62}, {37.66, 55.63}}), 6));

    EXPECT_TRUE(index.isInPrivateArea(
        Polyline2(PointsVector{{37.65, 55.62}, {37.66, 55.63}}), 7));
}

} // suite
} // namespace maps::mrc::graph_coverage_export::tests

