#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/common/include/threadpool_wrapper.h>

#include <maps/libs/introspection/include/comparison.h>
#include <maps/libs/concurrent/include/threadpool.h>

#include <functional>
#include <future>
#include <tuple>
#include <vector>

namespace maps::mrc::import_nexar {

using maps::introspection::operator==;

struct TileImportParams {
    int32_t geoId;
    int16_t fc;
    int32_t x;
    int32_t y;
    int32_t z;

    template<typename T>
    static auto introspect(T& t)
    {
        return std::tie(t.geoId, t.fc, t.x, t.y, t.z);
    }
};

template<typename Function,
         typename Collection,
         typename ResultType = std::invoke_result_t<Function, typename Collection::value_type>>
std::vector<ResultType> evalConcurently(Function func, size_t concurrency, const Collection& container)
{
    const size_t size = container.size();
    std::vector<ResultType> result;
    result.reserve(size);
    std::vector<std::future<ResultType>> futures;
    futures.reserve(size);

    common::ThreadpoolWrapper threadPool(concurrency);
    for (const auto& value : container) {
        futures.push_back(threadPool->async(func, value));
    }

    threadPool->drain();
    threadPool.checkExceptions();

    for (auto& future : futures) {
        result.push_back(std::move(future.get()));
    }
    return result;
}

inline std::string makeCurrentThreadLogPrefix()
{
    std::stringstream str;
    str << "[ " << std::this_thread::get_id() << " ] ";
    return str.str();
}

} // namespace maps::mrc::import_nexar
