#pragma once
#include "common.h"
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/nexar_import_tile_update_info.h>

#include <maps/libs/chrono/include/time_point.h>
#include <maps/libs/introspection/include/hashing.h>

#include <pqxx/transaction_base>

#include <optional>
#include <unordered_map>

namespace maps::mrc::import_nexar {

class Metadata {
public:
    Metadata() = default;
    Metadata(std::optional<chrono::TimePoint> lastSuccessRunTime,
            db::NexarImportTileUpdateInfos tileUpdateInfos);

    std::optional<chrono::TimePoint> lastSuccessRunTime() const { return lastSuccessRunTime_; }
    db::NexarImportTileUpdateInfos tileUpdateInfos() const;

    db::NexarImportTileUpdateInfo getTileUpdateInfo(const TileImportParams& tileParam) const;

    Metadata& setLastSuccessRunTime(std::optional<chrono::TimePoint> lastSuccessRunTime)
    {
        lastSuccessRunTime_ = std::move(lastSuccessRunTime);
        return *this;
    }

    void setTileUpdateInfo(db::NexarImportTileUpdateInfo info);

private:

    std::optional<chrono::TimePoint> lastSuccessRunTime_;
    std::unordered_map<TileImportParams, db::NexarImportTileUpdateInfo, introspection::Hasher>
        tileParamToInfo_;
};

Metadata loadMetadata(pqxx::transaction_base& txn);
void saveMetadata(pqxx::transaction_base& txn, Metadata& metadata);

} // namespace maps::mrc::import_nexar
