#pragma once

#include <maps/wikimap/mapspro/services/mrc/long_tasks/import_nexar/lib/nexar_client.h>

#include <library/cpp/testing/gmock_in_unittest/gmock.h>

namespace maps::mrc::import_nexar::tests {

class NexarClientMock : public INexarClient {
public:
    MOCK_METHOD(
        std::vector<NexarImageMeta>,
        search,
        (const NexarSpatialSearchParams&,
         const std::optional<chrono::TimePoint>&,
         size_t),
        (const override));

    MOCK_METHOD(std::string, loadImage, (const std::string&), (const override));
};

class TokenProviderMock: public ITokenProvider
{
public:
    MOCK_METHOD(std::string, getToken, (), (override));
    MOCK_METHOD(void, invalidateToken, (), (override));
};


} // namespace maps::mrc::import_nexar::tests
