#include <maps/libs/cmdline/include/cmdline.h>
#include <maps/libs/log8/include/log8.h>
#include <maps/wikimap/mapspro/services/mrc/long_tasks/import_taxi/lib/worker.h>

using namespace maps::mrc;

int main(int argc, char* argv[])
try {
    NYT::Initialize(argc, argv);
    maps::cmdline::Parser parser;
    auto configPath = parser
         .string("config")
         .help("path to configuration");

    auto secretVersion = parser
        .string("secret")
        .help("version for secrets from yav.yandex-team.ru");

    auto syslog = parser
        .string("syslog-tag")
        .help("redirect log output to syslog with given tag");

    auto graphFolder = parser.string("graph-dir")
        .defaultValue("/var/lib/yandex/maps/ecstatic/data/yandex-maps-mrc-graph-pro")
        .help("directory graph data is loaded from");

    auto geoIdCoveragePath = parser.string("geoid-coverage-path")
        .help("path to coverage5-geoid mms");

    auto dryRun = parser
        .flag("dry-run")
        .help("Do not commit to DB");

    parser.parse(argc, argv);

    if (syslog.defined()) {
        maps::log8::setBackend(maps::log8::toSyslog(syslog));
    }

    auto config =
        maps::mrc::common::templateConfigFromCmdPath(secretVersion, configPath);

    config.enableTvmClient();

    auto poolHolder = config.makePoolHolder(
        maps::mrc::common::LONG_READ_DB_ID,
        maps::mrc::common::LONG_READ_POOL_ID);

    const std::string geoIdCoveragePathStr =
        geoIdCoveragePath.defined()
            ? std::string(geoIdCoveragePath)
            : config.externals().geoIdCoveragePath();

    import_taxi::Worker worker(
        config,
        poolHolder.pool(),
        graphFolder,
        geoIdCoveragePathStr,
        dryRun);

    worker.run();

    return EXIT_SUCCESS;
} catch (const maps::Exception& e) {
    ERROR() << e;
    return EXIT_FAILURE;
} catch (const std::exception& e) {
    ERROR() << e.what();
    return EXIT_FAILURE;
}
