#pragma once

#include "video_events_feed.h"

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/track_point.h>
#include <maps/libs/chrono/include/time_point.h>

#include <mapreduce/yt/interface/client.h>

#include <string>
#include <unordered_map>

namespace maps::mrc::import_taxi {

class ITrackProvider
{
public:
    virtual void preloadTracks(const VideoEvents& videoEvents) = 0;

    virtual void clearTracks() = 0;

    virtual db::TrackPoints getTrack(const VideoEvent&) const = 0;

    virtual ~ITrackProvider() = default;
};

class TrackProvider : public ITrackProvider {
public:
    /**
     * @param trackTablesDir - yt path containing 1d/ and 1h/ logs of taxi devices' tracks
     * @param tmpTablePath   - yt path to temporary table to which tracks will be preloaded
     */
    TrackProvider(
        NYT::IClientBasePtr ytClient,
        const std::string& trackTablesDir,
        const std::string& tmpTablePath);

    void preloadTracks(const VideoEvents& videoEvents) override;

    // drop all preloaded tracks
    void clearTracks() override;

    db::TrackPoints getTrack(const VideoEvent&) const override;

private:
    NYT::IClientBasePtr ytClient_;
    std::string trackTablesDir_;
    TString tmpTablePath_;

    std::unordered_map<std::string, db::TrackPoints> deviceTracks_;
};

} // namespace maps::mrc::import_taxi
