#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/track_point.h>
#include <maps/wikimap/mapspro/services/mrc/libs/graph_matcher_adapter/include/matcher.h>
#include <maps/libs/chrono/include/time_point.h>

namespace maps::mrc::import_taxi {

/**
 * Picks a series of track points on every segment such that
 * for every two consecutive track points:
 *   - their time distance is not more than @param timeStep and
 *   - their space distance is not more than @param spaceStepMeters.
 */
db::TrackPoints pickTrackPoints(
    const adapters::TrackSegments& trackSegments,
    std::chrono::milliseconds timeStep,
    double spaceStepMeters);

} // namespace maps::mrc::import_taxi
