#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/track_point.h>
#include <maps/libs/chrono/include/time_point.h>

#include <mapreduce/yt/interface/client.h>
#include <string>
#include <unordered_map>

namespace maps::mrc::import_taxi {

struct VideoEvent {
    db::TId id;
    std::string eventType;
    std::string url;
    std::string sourceId;

    // The best guess is that eventTime corresponds to the end of video
    // as well as to the last recorded track point.
    maps::chrono::TimePoint eventTime;

    db::TrackPoints track;
};
using VideoEvents = std::vector<VideoEvent>;

class VideoEventsFeed {
public:
    explicit VideoEventsFeed(db::TId maxProcessedId)
        : maxProcessedId_(maxProcessedId)
    {}

    virtual ~VideoEventsFeed() = default;

    virtual bool hasNext() = 0;

    virtual VideoEvent next() = 0;

    db::TId maxProcessedId() const { return maxProcessedId_; }

protected:
    db::TId maxProcessedId_;
};


class TaxiVideoEventsFeed : public VideoEventsFeed {
public:
    TaxiVideoEventsFeed(
        NYT::IClientBasePtr client,
        const std::string& tablesDir,
        db::TId maxProcessedId);

    bool hasNext() override;

    VideoEvent next() override;

private:
    void readDeviceIdMap();

    std::string getSourceId(uint64_t deviceId) const;

    void moveToNextUsefulRow();

    TString eventsTablePath_;
    TString devicesTablePath_;

    NYT::IClientBasePtr ytClient_;
    NYT::TTableReaderPtr<NYT::TNode> eventsReader_;

    std::unordered_map<uint64_t, std::string> deviceIdMap_;
};

} // namespace maps::mrc::import_taxi
