#pragma once

#include "importer.h"

#include <maps/wikimap/mapspro/services/mrc/libs/config/include/config.h>
#include <yandex/maps/wiki/common/pgpool3_helpers.h>

#include <memory>

namespace maps::mrc::import_taxi {

class Worker
{
public:
    Worker(
        common::Config cfg,
        pgpool3::Pool& pool,
        const std::string& graphFolder,
        const std::string& geoIdPath,
        bool dryRun);

    void runOnce(pqxx::transaction_base& lockTxn);

    void run();

private:
    std::shared_ptr<VideoEventsFeed> makeTaxiEventsFeed(
        NYT::IClientBasePtr ytClient);

    std::unique_ptr<ITrackProvider> makeTrackProvider();

    common::Config cfg_;
    pgpool3::Pool& pool_;
    NYT::IClientBasePtr ytClient_;
    Importer importer_;

    bool dryRun_;
};

} // namespace maps::mrc::import_taxi
