#pragma once

#include "yt_types.h"
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/track_point.h>
#include <maps/wikimap/mapspro/services/mrc/libs/yt/include/common.h>
#include <maps/libs/chrono/include/time_point.h>

#include <mapreduce/yt/interface/client.h>
#include <mapreduce/yt/interface/common.h>

#include <string>

namespace maps::mrc::import_taxi {

struct TimeInterval {
    chrono::TimePoint begin;
    chrono::TimePoint end;
};
using TimeIntervals = std::vector<TimeInterval>;
using DeviceIdToTimeIntervals = std::unordered_map<std::string, TimeIntervals>;

TimeIntervals mergeTimeIntervals(TimeIntervals timeIntervals);

/**
 * Loads device tracks from raw taxi table(s) into output table
 * Takes only track points from specified intervals for each device ID.
 */
void loadSelectedTracks(
    NYT::IClientBase& client,
    const std::vector<TString>& inputTablePaths,
    const TString& outputTablePath,
    const DeviceIdToTimeIntervals& deviceToTimeIntervals);

} // namespace maps::mrc::import_taxi
