#pragma once

#include <maps/libs/chrono/include/time_point.h>
#include <util/generic/string.h>

#include <chrono>
#include <optional>
#include <string>

namespace maps::mrc::import_taxi {

namespace col {

const TString CONTRACTOR_UUID = "contractor_uuid";
const TString DIRECTION = "direction";
const TString LAT = "lat";
const TString LON = "lon";
const TString SPEED = "speed";
const TString UNIX_TIMESTAMP = "unix_timestamp";

} // namespace col

struct DeviceTrackRecord {
    std::string deviceId;
    int64_t timestampUsec;
    double lat;
    double lon;
    std::optional<double> speed;
    std::optional<double> direction;

    chrono::TimePoint timePoint() const {
        return chrono::sinceEpochToTimePoint<std::chrono::microseconds>(timestampUsec);
    }

    template<class T>
    static auto introspect(T& t)
    {
        return std::tie(
            t.deviceId,
            t.timestampUsec,
            t.lat,
            t.lon,
            t.speed,
            t.direction);
    }

    static auto columns() {
        return std::make_tuple(
            col::CONTRACTOR_UUID,
            col::UNIX_TIMESTAMP,
            col::LAT,
            col::LON,
            col::SPEED,
            col::DIRECTION);
    }
};

} // namespace maps::mrc::import_taxi
