#pragma once

#include <contrib/libs/aws-sdk-cpp/aws-cpp-sdk-s3/include/aws/s3/S3Client.h>

#include <string>

namespace maps::mrc::import_taxi::tests {

class S3Client {
public:
    S3Client();

    const std::string& port() const { return port_; }

    void createBucket();

    void emptyBucket();

    void upload(const std::string& key, const std::string& data);

    void uploadFile(const std::string& key, const std::string& fileName);

    std::string makeReadingUrl(const std::string& key) const;

private:
    std::string port_;
    std::string bucket_;
    std::shared_ptr<Aws::S3::S3Client> client_;
};

}  // namespace maps::mrc::import_taxi::tests
