#include <maps/wikimap/mapspro/services/mrc/long_tasks/import_taxi/lib/video_events_feed.h>

namespace maps::mrc::import_taxi::tests {

class StaticEventsFeed : public VideoEventsFeed {
public:
    explicit StaticEventsFeed(VideoEvents videoEvents)
        : VideoEventsFeed(-1 /*maxProcessedId*/)
        , videoEvents_(std::move(videoEvents))
    {}

    bool hasNext() override { return idx_ < videoEvents_.size(); };

    VideoEvent next() override
    {
        ASSERT(hasNext());
        auto event = videoEvents_[idx_++];
        maxProcessedId_ = event.id;
        return event;
    };

    void rewind()
    {
        idx_ = 0;
        maxProcessedId_ = -1;
    }

protected:
    VideoEvents videoEvents_;
    size_t idx_{0};
};

}  // namespace maps::mrc::import_taxi::tests
