#pragma once

#include <maps/libs/chrono/include/days.h>
#include <maps/libs/chrono/include/time_point.h>
#include <maps/libs/pgpool/include/pgpool3.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/disqualified_source.h>

#include <optional>

#include <pqxx/transaction_base>

namespace maps::mrc::red_card {

constexpr auto RECENT_TIMES = chrono::Days{7};
constexpr auto REQUIRED_PHOTOS = 100;
constexpr auto REQUIRED_PERCENTILE = .9;
constexpr auto ROAD_PROBABILITY_THRESHOLD = .5;

void updateLastRunTime(pgpool3::Pool&, chrono::TimePoint now);

std::optional<chrono::TimePoint> loadLastRunTime(pqxx::transaction_base&);

/// prepare modified/new DisqualifiedSource for @param sourceId
/// in interface for unit-test only
db::DisqualifiedSources prepareDisqualifiedSources(pqxx::transaction_base&,
                                                   const std::string& sourceId,
                                                   chrono::TimePoint now);

/// update/insert DisqualifiedSource for each sourceId if necessary
void updateDisqualifiedSources(pgpool3::Pool&,
                               chrono::TimePoint now,
                               bool dryRun);

}  // namespace maps::mrc::red_card
