#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/blackbox_client/include/blackbox_client.h>
#include <maps/wikimap/mapspro/services/mrc/libs/config/include/config.h>

#include <mapreduce/yt/client/client.h>

#include <yandex/maps/mds/mds.h>

namespace maps::mrc::regular_upload {

class RegularUploadConfig {
public:
    pgpool3::Pool* pool() const { return pool_; }

    const mds::Mds* mds() const { return mdsPtr_; }

    NYT::IClientBase* ytClient() const { return ytClientPtr_; }

    blackbox_client::IBlackboxClient* blackboxClient() const { return blackboxClientPtr_; }

    TString featuresTablePath() const { return featuresTablePath_; }

    size_t uploadBatchSize() const { return uploadBatchSize_; }

    RegularUploadConfig& setMds(const mds::Mds* mds)
    {
        mdsPtr_ = mds;
        return *this;
    }

    RegularUploadConfig& setPool(pgpool3::Pool* pool)
    {
        pool_ = pool;
        return *this;
    }

    RegularUploadConfig& setYtClient(NYT::IClientBase* client)
    {
        ytClientPtr_ = client;
        return *this;
    }

    RegularUploadConfig& setBlackboxClient(blackbox_client::IBlackboxClient* blackbox)
    {
        blackboxClientPtr_ = blackbox;
        return *this;
    }

    RegularUploadConfig& setFeaturesTablePath(const std::string& tablePath)
    {
        featuresTablePath_ = tablePath;
        return *this;
    }

    RegularUploadConfig& setUploadBatchSize(size_t batchSize)
    {
        uploadBatchSize_ = batchSize;
        return *this;
    }

private:
    pgpool3::Pool* pool_{nullptr};
    const maps::mds::Mds* mdsPtr_{nullptr};
    NYT::IClientBase* ytClientPtr_{nullptr};
    blackbox_client::IBlackboxClient* blackboxClientPtr_{nullptr};
    TString featuresTablePath_{};
    size_t uploadBatchSize_{1u};
};

} // maps::mrc::regular_upload
