#pragma once

#include <maps/libs/sql_chemistry/include/batch_load.h>
#include <maps/wikimap/mapspro/services/mrc/libs/blackbox_client/include/blackbox_client.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/feature_gateway.h>
#include <yandex/maps/mds/mds.h>

#include <unordered_map>

namespace maps::mrc::regular_upload {

class RegularUploadConfig;

class RegularUploader {
public:
    explicit RegularUploader(const RegularUploadConfig& cfg);

    uint64_t loadAndSaveFromDatabase() const;

private:
    blackbox_client::UidToLoginMap getUserLogins(
        sql_chemistry::BatchLoad<db::table::Feature>&
    ) const;

    void saveFeatureToYtTable(
        NYT::TTableWriterPtr<NYT::TNode> writer,
        const db::Feature&,
        const blackbox_client::UidToLoginMap& userLogins) const;

    uint64_t loadAndWriteFeature(pgpool3::TransactionHandle& txn, NYT::TTableWriterPtr<NYT::TNode> writer) const;

private:
    const RegularUploadConfig& cfg_;
};

} // maps::mrc::regular_upload
