#pragma once

#include <library/cpp/testing/common/env.h>
#include <library/cpp/testing/gtest/gtest.h>
#include <mapreduce/yt/tests/yt_unittest_lib/yt_unittest_lib.h>
#include <maps/wikimap/mapspro/services/mrc/libs/blackbox_client/include/blackbox_client.h>
#include <yandex/maps/mrc/unittest/database_fixture.h>

#include <array>
#include <tuple>

namespace maps::mrc::regular_upload::tests {

class Fixture : public testing::Test,
                public unittest::WithUnittestConfig<unittest::DatabaseFixture>
{
public:
    Fixture()
    {
        auto txn = pool().masterWriteableTransaction();
        txn->exec(maps::common::readFileToString(SRC_("data.sql")));
        txn->commit();
    }
};

struct MockBlackboxClient : blackbox_client::IBlackboxClient {
    MOCK_METHOD(std::optional<blackbox_client::Uid>,
                uidByLogin,
                (const std::string&),
                (const, override));
    MOCK_METHOD(blackbox_client::UidToLoginMap,
                uidToLoginMap,
                (blackbox_client::Uids),
                (const, override));
    MOCK_METHOD(blackbox_client::UidToUserInfoMap,
                uidToUserInfoMap,
                (blackbox_client::Uids, const blackbox_client::QueryParams&),
                (const, override));
};

} // namespace maps::mrc::regular_upload::tests
