#include "context.h"

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/feature_gateway.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/queued_photo_id_gateway.h>

namespace maps {
namespace mrc {
namespace ride_inspector {

Context::Context(const common::Config& cfg)
    : poolHolder_(cfg.makePoolHolder(maps::mrc::common::LONG_READ_DB_ID,
                                     maps::mrc::common::LONG_READ_POOL_ID))
{
}

pgpool3::Pool& Context::pool() { return poolHolder_.pool(); }

db::rides::QueuedPhotoIds Context::loadQueuedPhotoIds()
{
    auto txn = poolHolder_.pool().slaveTransaction();
    return db::QueuedPhotoIdGateway{*txn}.load();
}

void Context::deleteQueuedPhotoIds(const sql_chemistry::Filter& filter)
{
    auto txn = poolHolder_.pool().masterWriteableTransaction();
    db::QueuedPhotoIdGateway{*txn}.remove(filter);
    txn->commit();
}

} // ride_inspector
} // mrc
} // maps
