#pragma once

#include <maps/libs/pgpool/include/pgpool3.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/ride.h>

#include <functional>

namespace maps::mrc::ride_inspector {

using HypothesisIdConsumer =
    std::function<void(sql_chemistry::Transaction&, db::TId hypothesisId)>;

bool hypothesesQueuePop(pgpool3::Pool&, const HypothesisIdConsumer&);

size_t hypothesesQueueSize(sql_chemistry::Transaction&);

std::optional<db::RideHypothesis> tryMakeRideHypothesis(
    sql_chemistry::Transaction&,
    db::TId hypothesisId);

db::RideHypotheses makeRideHypotheses(sql_chemistry::Transaction&,
                                      const db::Ride&);

}  // namespace maps::mrc::ride_inspector
