#pragma once

#include <maps/libs/pgpool/include/pgpool3.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/feature.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/ride.h>

namespace maps::mrc::ride_inspector {

db::Ride makeRide(db::Features::iterator first, db::Features::iterator last);

/**
 * Actualize ride with the specified parameters in the database.
 * If clientRideId is missing and time gaps allow,
 * several rides can be merged into one by marking rest of them as deleted.
 */
void updateRides(pgpool3::Pool& pool,
                 const std::string& userId,
                 const std::string& sourceId,
                 const std::optional<std::string>& clientRideId,
                 chrono::TimePoint minTime,
                 chrono::TimePoint maxTime);

/// Update all rides for specified photos
void updateRidesByPhotoIds(pgpool3::Pool&, const db::TIds& photoIds);

}  // namespace maps::mrc::ride_inspector
