#pragma once

#include <maps/libs/pgpool/include/pgpool3.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/frame.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/object.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/recognition.h>
#include "maps/wikimap/mapspro/services/mrc/long_tasks/signs_export_gen/lib/utils.h"

#include <pqxx/transaction_base>

namespace maps::mrc::signs_export_gen {

db::TIds
loadSignIds(pqxx::transaction_base& txn);

std::vector<db::eye::Object>
loadObjects(
    pqxx::transaction_base& txn,
    const db::TIds& objectIds);

db::IdTo<db::eye::ObjectLocation>
loadObjectLocations(
    pqxx::transaction_base& txn,
    const db::TIds& objectIds);

using ObjectIdToDetectionIds = db::IdTo<db::TIds>;

std::pair<db::eye::Detections, ObjectIdToDetectionIds>
loadObjectDetections(
    pqxx::transaction_base& txn,
    const db::eye::Objects& objects);

using FrameIds = db::TIds;
using DetectionIdToFrameId = db::IdTo<db::TId>;

std::pair<FrameIds, DetectionIdToFrameId>
loadFramesWithDetections(
    pqxx::transaction_base& txn,
    const db::eye::Detections& detections);

using ObjectIdToFrameIds = db::IdTo<FrameIds>;

std::pair<FrameIds, ObjectIdToFrameIds>
loadFramesWithMissingObjects(
    pqxx::transaction_base& txn,
    const db::TIds& objectIds);

db::IdTo<db::eye::Frame>
loadFrames(
    pqxx::transaction_base& txn,
    const db::TIds& frameIds);

db::IdTo<db::eye::FrameLocation>
loadFrameLocations(
    pqxx::transaction_base& txn,
    const db::TIds& frameIds);

db::IdTo<std::vector<traffic_signs::TrafficSign>>
loadAdditionalTables(
    pqxx::transaction_base& txn,
    const db::TIds& objectIds);


db::eye::DetectionGroups
loadDetectionGroups(
    pqxx::transaction_base& txn,
    const db::TIds& frameIds);

db::eye::Detections
loadDetections(
    pqxx::transaction_base& txn,
    const db::TIds& detGroupIds);

db::IdTo<db::TId>
loadDetectionIdToObjectId(
    pqxx::transaction_base& txn,
    const db::TIds& detectionIds);

void removeAdditionalTables(db::eye::Objects& objects);

}  // namespace maps::mrc::signs_export_gen
