#include "tools.h"

#include <maps/libs/log8/include/log8.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/metadata_gateway.h>

namespace maps::mrc::signs_export_gen {

void updateLastRunTime(pgpool3::Pool& pool, chrono::TimePoint now)
{
    auto txn = pool.masterWriteableTransaction();
    db::MetadataGateway{*txn}.upsertByKey(LAST_RUN_TIME,
                                          chrono::formatSqlDateTime(now));
    txn->commit();
}

std::optional<chrono::TimePoint> loadLastRunTime(pqxx::transaction_base& txn)
{
    auto result = db::MetadataGateway{txn}.tryLoadByKey(LAST_RUN_TIME);
    if (!result) {
        return std::nullopt;
    }
    return chrono::parseSqlDateTime(*result);
}

} // maps::mrc::signs_export_gen
