#pragma once

#include <maps/libs/chrono/include/time_point.h>
#include <maps/libs/pgpool/include/pgpool3.h>

#include <pqxx/transaction_base>

#include <optional>
#include <string>

namespace maps::mrc::signs_export_gen {

const std::string APP_NAME = "signs_export_gen";
const std::string LAST_RUN_TIME = APP_NAME + ".timestamp";
const std::string ECSTATIC_DATASET_NAME = "yandex-maps-mrc-objects";

void updateLastRunTime(pgpool3::Pool&, chrono::TimePoint now);

std::optional<chrono::TimePoint> loadLastRunTime(pqxx::transaction_base&);

}  // namespace maps::mrc::signs_export_gen
