#pragma once

#include <maps/libs/chrono/include/time_point.h>
#include <maps/libs/pgpool/include/pgpool3.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/frame.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/object.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/recognition.h>

#include <pqxx/transaction_base>

#include <vector>

namespace maps::mrc::signs_export_gen {

enum class GroupAlignment { Horizontal, Vertical };

struct SignGroup {
    db::TId groupId;
    db::TIds objectIds;
    GroupAlignment alignment;
};

using SignGroups = std::vector<SignGroup>;
using ObjectIdToGroupId = db::IdTo<db::TId>;

std::pair<SignGroups, ObjectIdToGroupId>
collectTrafficSignGroups(pgpool3::Pool& pool);

}  // namespace maps::mrc::signs_export_gen
