-- features
INSERT INTO signals.feature (feature_id, date, dataset, source_id, mds_group_id, mds_path, pos, heading, width, height, orientation, is_published, privacy) VALUES
(1, '2022-07-01 10:00:00.000+03', 'agents', 'src', '100500',  'mrc/ugc/images/1', ST_Transform(ST_GeomFromText('POINT(44.014979 56.312491)', 4326), 3395), 150.0, 1920, 1080, 1, true, 'public'),
(2, '2022-07-02 10:00:00.000+03', 'agents', 'src', '100500',  'mrc/ugc/images/2', ST_Transform(ST_GeomFromText('POINT(44.014989 56.312493)', 4326), 3395), 150.0, 1920, 1080, 1, true, 'secret'),
(3, '2022-07-03 10:00:00.000+03', 'agents', 'src', '100500',  'mrc/ugc/images/3', ST_Transform(ST_GeomFromText('POINT(44.014912 56.312550)', 4326), 3395), 150.0, 1920, 1080, 1, true, 'public'),
(4, '2022-07-04 10:00:00.000+03', 'agents', 'src', '100500',  'mrc/ugc/images/4', ST_Transform(ST_GeomFromText('POINT(44.014995 56.312486)', 4326), 3395), 150.0, 1920, 1080, 1, true, 'public'),
(5, '2022-07-05 10:00:00.000+03', 'agents', 'src', '100500',  'mrc/ugc/images/5', ST_Transform(ST_GeomFromText('POINT(44.015002 56.312524)', 4326), 3395), 150.0, 1920, 1080, 3, true, 'public'),
(6, '2022-07-06 10:00:00.000+03', 'agents', 'src', '100500',  'mrc/ugc/images/6', ST_Transform(ST_GeomFromText('POINT(44.014589 56.319380)', 4326), 3395), 330.0, 1920, 1080, 1, false, 'public'),
(7, '2022-07-07 10:00:00.000+03', 'agents', 'src', '100500',  'mrc/ugc/images/7', ST_Transform(ST_GeomFromText('POINT(44.014550 56.319325)', 4326), 3395), 150.0, 1920, 1080, 1, true, 'public');

-- panoramas
INSERT INTO signals.eye_panorama (oid, txn_id, date, session_id, order_num, position, vehicle_course_deg, deleted) VALUES
('1_2_3_4', 21,'2022-07-08 10:00:00.000+03', 1, 1, ST_GeomFromText('POINT(44.015100 56.312600)', 4326), 80, false);

-- devices
INSERT INTO eye.device (device_id, txn_id, attrs) VALUES
(18001, 10, '{"model": "Pixel 4", "source": "mrc"}'),
(18002, 20, '{"hfov": 90, "source": "panorama"}');

-- feature frames
INSERT INTO eye.frame (frame_id, device_id, txn_id, deleted, orientation, url_context, time, width, height) VALUES
(1, 18001, 11, false, 1, '{"source": "mrc", "mds_path": "mrc/ugc/images/1", "feature_id": 1, "mds_group_id": "100500"}', '2022-07-01 10:00:00.000+03', 1920, 1080),
(2, 18001, 12, false, 1, '{"source": "mrc", "mds_path": "mrc/ugc/images/2", "feature_id": 2, "mds_group_id": "100500"}', '2022-07-02 10:00:00.000+03', 1920, 1080),
(3, 18001, 13, false, 1, '{"source": "mrc", "mds_path": "mrc/ugc/images/3", "feature_id": 3, "mds_group_id": "100500"}', '2022-07-03 10:00:00.000+03', 1920, 1080),
(4, 18001, 14, false, 1, '{"source": "mrc", "mds_path": "mrc/ugc/images/4", "feature_id": 4, "mds_group_id": "100500"}', '2022-07-04 10:00:00.000+03', 1920, 1080),
(5, 18001, 15, false, 1, '{"source": "mrc", "mds_path": "mrc/ugc/images/5", "feature_id": 5, "mds_group_id": "100500"}', '2022-07-05 10:00:00.000+03', 1920, 1080),
(6, 18001, 16, false, 3, '{"source": "mrc", "mds_path": "mrc/ugc/images/6", "feature_id": 6, "mds_group_id": "100500"}', '2022-07-06 10:00:00.000+03', 1920, 1080),
(7, 18001, 17, true,  1, '{"source": "mrc", "mds_path": "mrc/ugc/images/7", "feature_id": 7, "mds_group_id": "100500"}', '2022-07-07 10:00:00.000+03', 1920, 1080);

-- panorama frames
INSERT INTO eye.frame (frame_id, device_id, txn_id, deleted, orientation, url_context, time, width, height) VALUES
(8, 18002, 21, false,  1, '{"oid": "1_2_3_4", "tilt": 0, "width": 1920, "height": 1080, "source": "panorama", "heading": 80, "horizontal_fov": 90}', '2022-07-08 10:00:00.000+03', 1920, 1080);

-- feature-to-frame
INSERT INTO eye.feature_to_frame (feature_id, frame_id) VALUES (1, 1), (2, 2), (3, 3), (4, 4), (5, 5), (6, 6), (7, 7);

-- panorama-to-frame
INSERT INTO eye.panorama_to_frame (oid, frame_id, heading, tilt, hfov, width, height) VALUES ('1_2_3_4', 8, 100, 0, 90, 1920, 1080);

-- frame locations
INSERT INTO eye.frame_location (frame_id, txn_id, position, rotation, move) VALUES
(1, 21, ST_Transform(ST_GeomFromText('POINT(44.014979 56.312491)', 4326), 3395), '{-0.686121,-0.170992,-0.170992,-0.686121}', '{0.469283,-0.883048,0}'),
(2, 22, ST_Transform(ST_GeomFromText('POINT(44.014989 56.312493)', 4326), 3395), '{0.645563,0.151226,0.169682,0.7291}', '{0.461921,-0.886921,0}'),
(3, 23, ST_Transform(ST_GeomFromText('POINT(44.014912 56.312550)', 4326), 3395), '{0.66017,0.172467,0.173597,0.710138}', '{0.449789,-0.893135,0}'),
(4, 24, ST_Transform(ST_GeomFromText('POINT(44.014995 56.312486)', 4326), 3395), '{0.65778,0.181356,0.183158,0.707735}', '{0.473714,-0.880679,0}'),
(5, 25, ST_Transform(ST_GeomFromText('POINT(44.015002 56.312524)', 4326), 3395), '{0.684238,-0.133224,-0.118807,0.707074}', '{0.463105,-0.886303,0}'),
(6, 26, ST_Transform(ST_GeomFromText('POINT(44.014589 56.319380)', 4326), 3395), '{-0.686121,-0.170992,-0.170992,-0.686121}', '{0.469284,-0.883047,0}'),
(7, 27, ST_Transform(ST_GeomFromText('POINT(44.014550 56.319325)', 4326), 3395), '{-0.686121,-0.170992,-0.170992,-0.686121}', '{0.469284,-0.883047,0}'),
(8, 28, ST_Transform(ST_GeomFromText('POINT(44.014589 56.319380)', 4326), 3395), '{0.679876,0.194341,-0.194341,-0.679876}', '{-0.528511,0.848926,0}');

-- detection groups
INSERT INTO eye.detection_group (group_id, frame_id, txn_id, approved, type) VALUES
(1, 1, 31, true, 'sign'),
(2, 2, 32, true, 'sign'),
(3, 3, 33, true, 'sign'),
(4, 4, 34, true, 'sign'),
(5, 5, 35, true, 'sign'),
(6, 6, 36, true, 'sign'),
(7, 7, 37, true, 'traffic_light'),
(8, 8, 38, true, 'sign');

-- detections
INSERT INTO eye.detection (detection_id, group_id, txn_id, deleted, attrs) VALUES
-- detections on frame 1:
    -- sign 1 with two additional tables
    (110, 1, 1001, false, '{"box": [[100, 100], [300, 300]], "type": "prohibitory_no_parking_or_stopping", "temporary": false, "type_confidence": 1, "temporary_confidence": 1}'),
    (111, 1, 1001, false, '{"box": [[90, 300], [310, 400]], "type": "information_heavy_vehicle", "temporary": false, "type_confidence": 1, "temporary_confidence": 1}'),
    (112, 1, 1001, false, '{"box": [[90, 400], [310, 500]], "type": "information_in_zone", "temporary": false, "type_confidence": 1, "temporary_confidence": 1}'),
    -- sign 2
    (120, 1, 1001, false, '{"box": [[300, 300], [400, 400]], "type": "priority_give_way", "temporary": false, "type_confidence": 1, "temporary_confidence": 1}'),
    -- sign 3
    (130, 1, 1001, false, '{"box": [[300, 450], [400, 550]], "type": "mandatory_proceed_straight_or_turn_right", "temporary": false, "type_confidence": 1, "temporary_confidence": 1}'),
    -- sign 4
    (140, 1, 1001, false, '{"box": [[600, 600], [700, 700]], "type": "prescription_one_way_road", "temporary": false, "type_confidence": 1, "temporary_confidence": 1}'),

-- detections on frame 2:
    -- sign 1
    (210, 2, 1002, false, '{"box": [[100, 100], [300, 300]], "type": "prohibitory_no_parking_or_stopping", "temporary": false, "type_confidence": 1, "temporary_confidence": 1}'),

-- detections on frame 3:
    -- sign 1
    (310, 3, 1003, false, '{"box": [[900, 900], [1000, 1000]], "type": "prohibitory_no_parking_or_stopping", "temporary": false, "type_confidence": 1, "temporary_confidence": 1}'),

-- detections on frame 4:
    -- sign 2
    (420, 4, 1004, false, '{"box": [[100, 100], [300, 300]], "type": "priority_give_way", "temporary": false, "type_confidence": 1, "temporary_confidence": 1}'),
    -- sign 3
    (430, 4, 1004, false, '{"box": [[100, 300], [300, 500]], "type": "mandatory_proceed_straight_or_turn_right", "temporary": false, "type_confidence": 1, "temporary_confidence": 1}'),

-- detections on frame 5 are missing

-- detections on frame 6 (deleted)
    -- sign 5
    (650, 6, 1006, true, '{"box": [[100, 100], [200, 200]], "type": "warning_uneven_road_ahead", "temporary": false, "type_confidence": 1, "temporary_confidence": 1}'),

-- detections on frame 7 (traffic_light)
    (700, 7, 1007, false, '{"box": [[358, 217], [404, 359]], "confidence": 1}'),

-- detections on frame 8 (panorama)
    -- sign 1 with two additional tables
    (810, 8, 1008, false, '{"box": [[800, 200], [900, 400]], "type": "prohibitory_no_parking_or_stopping", "temporary": false, "type_confidence": 1, "temporary_confidence": 1}'),
    (811, 8, 1008, false, '{"box": [[790, 400], [910, 500]], "type": "information_heavy_vehicle", "temporary": false, "type_confidence": 1, "temporary_confidence": 1}'),
    (812, 8, 1008, false, '{"box": [[790, 500], [910, 600]], "type": "information_in_zone", "temporary": false, "type_confidence": 1, "temporary_confidence": 1}');

--primary detection relations
INSERT INTO eye.primary_detection_relation (relation_id, primary_detection_id, detection_id, txn_id, deleted) VALUES
(1, 110, 210, 1002, false),
(2, 110, 310, 1003, false),
(3, 110, 810, 1008, false),
(4, 111, 811, 1008, false),
(5, 112, 812, 1008, false),
(6, 120, 420, 1004, false),
(7, 130, 430, 1004, false);

-- objects
INSERT INTO eye.object (object_id, primary_detection_id, txn_id, deleted, type, attrs, disappeared_at) VALUES
(1,   110, 2001, false, 'sign', '{"type": "prohibitory_no_parking_or_stopping", "temporary": false}', null),
(2,   120, 2002, false, 'sign', '{"type": "priority_give_way", "temporary": false}', null),
(3,   130, 2003, false, 'sign', '{"type": "mandatory_proceed_straight_or_turn_right", "temporary": false}', null),
(4,   140, 2004, false, 'sign', '{"type": "prescription_one_way_road", "temporary": false}', '2022-07-05 10:00:00.000+03'),
(11,  111, 2001, false, 'sign', '{"type": "information_heavy_vehicle", "temporary": false}', null),
(12,  112, 2001, false, 'sign', '{"type": "information_in_zone", "temporary": false}', null),
(700, 700, 2007, false, 'traffic_light', '{}', null);

-- object locations
INSERT INTO eye.object_location (object_id, txn_id, position, rotation) VALUES
(1,   2001, ST_Transform(ST_GeomFromText('POINT(44.015018 56.312356)', 4326), 3395), '{0.705505,-0.0475696,0.0475696,-0.705505}'),
(2,   2002, ST_Transform(ST_GeomFromText('POINT(44.015007 56.312359)', 4326), 3395), '{0.705898,0.0413252,-0.0413252,-0.705898}'),
(3,   2003, ST_Transform(ST_GeomFromText('POINT(44.015133 56.312226)', 4326), 3395), '{0.704821,-0.0568042,0.0568042,-0.704821}'),
(4,   2004, ST_Transform(ST_GeomFromText('POINT(44.014047 56.319888)', 4326), 3395), '{0.140453,-0.693017,0.693017,-0.140453}'),
(11,  2011, ST_Transform(ST_GeomFromText('POINT(44.015018 56.312356)', 4326), 3395), '{0.705505,-0.0475696,0.0475696,-0.705505}'),
(12,  2012, ST_Transform(ST_GeomFromText('POINT(44.015018 56.312356)', 4326), 3395), '{0.705505,-0.0475696,0.0475696,-0.705505}'),
(700, 2700, ST_Transform(ST_GeomFromText('POINT(44.015099 56.312019)', 4326), 3395), '{0.523291,0.475569,-0.475569,-0.523291}');

-- object relations
INSERT INTO eye.object_relation (relation_id, master_object_id, slave_object_id, txn_id, deleted) VALUES
(1, 1, 11, 3011, false),
(2, 1, 12, 3012, false);

-- object missing on frame
INSERT INTO eye.object_missing_on_frame (id, txn_id, object_id, frame_id, deleted) VALUES
(1, 4004, 4, 5, false);
