#pragma once

#include "data_model.h"

namespace maps::mrc::gen_targets{

using ComponentId = std::size_t;

const std::function<bool(EdgeId)> allEdges = [](EdgeId){ return true; };

// This is an implementation of the Kosaraju's algorithm (find
// Strongly Connected Components of a graph).
//
// param roadNetwork - full road graph
// param filter - a function to extract subgraph to work
// with (the whole graph by default).
// returns - assigns a Strongly Connected Component ID to each
// filtered edge and returns it as a hash table.
//
// WARNINIG: Due to the graph pecularities it is possible that
// a component ID is assignmed to a standalone edge. This implementation
// doesn't filter out such "components" in spite they do not form a real SCC.
std::unordered_map<EdgeId, ComponentId> getStronglyConnectedComponents(
    const RoadNetworkData& roadNetwork,
    std::function<bool(EdgeId)> filter = allEdges);

// Divides the edges into the Weakly Connected Components.
// (two edges are in one component if at least one edge is
// reachable from another using a path that consists only of target edges).
//
// param roadNetwork - full road graph
// param filter - a function to extract subgraph to work
// with (the whole graph by default).
// returns - assigns a Weakly Connected Component ID to each
// filtered edge and returns it as a hash table.
std::unordered_map<EdgeId, ComponentId> getWeaklyConnectedComponents(
    const RoadNetworkData& roadNetwork,
    std::function<bool(EdgeId)> filter = allEdges);

} // namespace maps::mrc::gen_targets
