#pragma once

#include "data_model.h"

#include <maps/libs/geolib/include/units_literals.h>
#include <maps/libs/log8/include/log8.h>

namespace maps::mrc::gen_targets {

// Deadend point - is an end of edge on two-way road, that has only one output
// edge - the reverse edge. All the edges(of both direction) on the road between
// deadend point and the nearest crossroad are considered as deadend edges.
// Edges with (fc > maxAllowedFc) will be temporary removed from graph
// before calculating deadends.
std::unordered_set<EdgeId> getDeadEnds(const RoadNetworkData& roadNetwork,
                                       const std::vector<int>& allowedFc);

} // namespace maps::mrc::gen_targets
