#pragma once

#include "data_model.h"

namespace maps::mrc::gen_targets {

std::unordered_set<EdgeId> getEdgesWithinDistricts(
    const RoadNetworkData& roadNetwork,
    const std::vector<District>& districts,
    int minRoadFc,
    int maxRoadFc);

std::unordered_set<EdgeId> getEdgesFromJsonPolygons(
    const RoadNetworkData& roadNetwork,
    const std::string& geojsonPolygonsFile,
    int minRoadFc,
    int maxRoadFc);

std::vector<District> convertMultiDistrictToDistricts(
    std::vector<MultiDistrict>& multiDistricts);

} // namespace maps::mrc::gen_targets
