#pragma once

#include "data_model.h"

#include <string>
#include <fstream>
#include <cmath>

namespace maps::mrc::gen_targets {

// @brief Saves paths to easyview text file
class EasyViewSaver {
public:
    EasyViewSaver(std::string outputFile) : ostream_(outputFile) {}

    // @brief draw path as a colored route with proper bidirectional rendering
    void saveTarget(const RoadNetworkData& data,
                    const Path& target);

    // @brief draw edges of paths using different colors for each path
    void saveTargets(std::vector<std::pair<District, PathWithData>>& targets);

    // @brief draw edges of paths using different colors for each path
    void saveTargets2(RoadNetworkData& data, std::vector<std::pair<District, Path>>& targets);

    // @brief draw barriers and adjoinent edges
    void saveBarriers(RoadNetworkData& data);



private:
    // draws a polygon exterior polyline
    void drawPolygon(geolib3::Polygon2 polygon, const std::string& label);
    void drawSegments(const std::vector<geolib3::Segment2>& segments,
                      bool shiftSide, int id);

    std::string getColor(size_t index);

    // for drawing bidirectional roads
    std::vector<geolib3::Point2> moveToRoadSide(const geolib3::Point2& p1,
                                                const geolib3::Point2& p2,
                                                double shift);

private:
    std::ofstream ostream_;
};

} // namespace maps::mrc::gen_targets
