#pragma once

#include "connected_components.h"
#include <unordered_set>

namespace maps::mrc::gen_targets {

// Divides all the edges to the strongly connected components.
// Then takes the largest strongly connected component(consider that all
// the other components are closed(by barriers) areas)
// Then divides all the target edges inside the largest strongly
// connected component into weakly connected components of targets.
// (two target edges are in one component if at least one edge is
// reachable from another using a path that consists only of target edges).
// Returns each component of targets as a vector of the targets edges.
std::vector<std::vector<EdgeId>> getFilteredConnectedComponentsOfTargets(
    const RoadNetworkData& roadNetwork,
    const std::unordered_set<EdgeId>& targetEdges);

// Divides all the edges to the strongly connected components.
// Finds the largest strongly connected component(consider that all
// the other components are closed(by barriers) areas)
// Returns all the edges from the other components.
std::unordered_set<EdgeId> getEdgesInClosedAreas(
    const RoadNetworkData& roadNetwork);

} // namespace maps::mrc::gen_targets
