#pragma once

#include "data_model.h"

#include <string>
#include <vector>

namespace maps::mrc::gen_targets {

std::vector<MultiDistrict> readPolygonsFromJsonFile(const std::string& path);

void savePolygonsToJsonFile(std::vector<MultiDistrict> multiDisctricts,
                            const std::string& path);

std::pair<std::vector<std::pair<District, Path>>, RoadNetworkData>
createTasksFromGeojsons(const std::string& dirPath);

void saveTasksToJsonFile(std::vector<std::pair<District, PathWithData>>& tasks,
                         const std::string& path);

} // namespace maps::mrc::gen_targets
