#pragma once

#include <maps/libs/geolib/include/direction.h>
#include <maps/libs/geolib/include/prepared_polygon.h>
#include <maps/libs/geolib/include/polygon.h>
#include <maps/libs/geolib/include/bounding_box.h>

#include <utility>

namespace maps::mrc::gen_targets {

bool angleInRange(double angle, std::pair<double, double> range);

// we need to check spatial relation between a polygon and a point
// but geolib3 has optimized spatial relation function only for
// two polygons
geolib3::Polygon2 generateSmallPolygonFromPoint(geolib3::Point2 point);
bool pointIsInsidePolygon(const geolib3::Point2 point,
                          const geolib3::PreparedPolygon2& polygon,
                          const geolib3::BoundingBox& polygonBbox);

// @brief returns true if at least half of the polyline is inside the polygon
bool polylineIsMostlyInsidePolygon(const geolib3::Polyline2& polyline,
                                   const geolib3::PreparedPolygon2& polygon,
                                   const geolib3::BoundingBox& polygonBbox);

bool turnIsRight(const geolib3::Direction2 direction1, const geolib3::Direction2 direction2);
bool turnIsLeft(const geolib3::Direction2 direction1, const geolib3::Direction2 direction2);
bool turnIsStraight(const geolib3::Direction2 direction1, const geolib3::Direction2 direction2);
bool turnIsUTurn(const geolib3::Direction2 direction1, const geolib3::Direction2 direction2);

} // namespace maps::mrc::gen_targets
