#include "mrc_saver.h"

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/ugc/gateway.h>
#include <maps/wikimap/mapspro/services/mrc/libs/config/include/config.h>

#include <chrono>
#include <unordered_set>

namespace ugc = maps::mrc::db::ugc;
namespace db = maps::mrc::db;

namespace maps::mrc::gen_targets {

ugc::Task createOutputTask(std::pair<District, PathWithData> task)
{
    ugc::Task outputTask;
    auto &path = task.second;
    double distance = 0;
    std::chrono::seconds duration(0);

    uint32_t i = 0;
    for (PathEdgeWithData& pathEdge : path) {
        if (pathEdge.isUsefulAsTarget) {
            const Edge& edge = pathEdge.edge;
            double length = edge.length;
            distance += length;
            duration += std::chrono::seconds(static_cast<long int>(length / 10));

            outputTask.addTarget(
                edge.geom,
                ugc::Oneway::No,
                ugc::Traffic::RightHand,
                ugc::Direction::Forward,
                i,
                std::nullopt
                );
            i++;
        }
    }

    outputTask.setDuration(duration);
    outputTask.setDistanceInMeters(distance);
    outputTask.setGeodeticHull(
        geolib3::MultiPolygon2(std::vector<geolib3::Polygon2>{task.first.area}));
    outputTask.addName(task.first.name.locale, task.first.name.name);
    return outputTask;
}

void saveTasks(const std::string& mrcConfig,
               std::vector<std::pair<District, PathWithData>>& tasks)
{
    auto conf = [&] {
        vault_boy::DirectoryContext ctx{common::KEYS_PATH};
        return mrcConfig.empty() ? common::Config{ctx} : common::Config{ctx, mrcConfig};
    }();
    auto poolHolder = conf.makePoolHolder(maps::mrc::common::LONG_READ_DB_ID,
                                          maps::mrc::common::LONG_READ_POOL_ID);
    auto transactionHandle = poolHolder.pool().masterWriteableTransaction();

    db::ugc::TaskGateway gtw{*transactionHandle};
    for (auto& task : tasks) {
        ugc::Task outputTask = createOutputTask(task);
        gtw.insert(outputTask);
    }
    transactionHandle->commit();
}

} // namespace maps::mrc::gen_targets
