#pragma once

#include "data_model.h"

#include <maps/libs/edge_persistent_index/include/persistent_index.h>
#include <maps/libs/road_graph/include/graph.h>
#include <maps/libs/succinct_rtree/include/rtree.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/ugc/tasks_group.h>
#include <maps/wikimap/mapspro/services/mrc/libs/fb/include/read.h>

namespace maps::graph2 {

class GraphObjects;

} // namespace maps::graph2

namespace maps::mrc::gen_targets {

// @brief static_graph loader
class StaticGraphLoader {
public:
    explicit StaticGraphLoader(
        const std::string& graphFolder =
            "/var/lib/yandex/maps/ecstatic/data/yandex-maps-mrc-graph-pro");
    ~StaticGraphLoader();

    // @brief loads graph including allowed turns information
    // @param allowedUturnsFc: allow all uTurns on the
    // crossroads with edges fc >= allowedUturnsFc
    RoadNetworkData loadGraph(const maps::geolib3::BoundingBox bbox,
                              size_t allowedUturnsFc,
                              bool allowTollRoads = false);

    void removeActualizedEdges(const db::ugc::TasksGroup&,
                               std::unordered_set<EdgeId>&) const;

    const fb::GraphReader& coverage() const { return coverage_; }

private:
    using EdgeIdToIndexMap = std::unordered_map<road_graph::EdgeId, size_t>;

    road_graph::Graph graph_;
    road_graph::PersistentIndex persistentIndex_;
    succinct_rtree::Rtree rtree_;

    fb::GraphReader coverage_;
    EdgeIdToIndexMap coveredEdgeIdToIndexMap_;
};


} // namespace maps::mrc::gen_targets
