#pragma once

#include "data_model.h"

#include <maps/libs/geolib/include/polygon.h>
#include <maps/libs/geolib/include/multipolygon.h>

#include <functional>

namespace maps::mrc::gen_targets {

using EdgeFilter = std::function<bool(const Edge&)>;

std::unordered_set<EdgeId> selectTargetEdges(
    const RoadNetworkData& roadNetwork,
    const geolib3::Polygon2& polygon,
    EdgeFilter filter);

std::unordered_set<EdgeId> selectTargetEdges(
    const RoadNetworkData& roadNetwork,
    const geolib3::MultiPolygon2& polygon,
    EdgeFilter filter);


Paths generateTasks(RoadNetworkData& roadNetwork,
                    const std::unordered_set<EdgeId>& targetEdges,
                    double minTaskLength);


// @brief generates one or more tasks for each district.
// prohibitedEdges will be modified: it will also contain all the
// visited edges
// roadNetworkData will be modified: all the edges will be marked as non-target
std::vector<std::pair<District, Path>>
generateTasksWithinDistricts(
    RoadNetworkData& roadNetwork,
    const std::vector<District>& districts,
    int maxRoadFc,
    double minTaskLength,
    std::unordered_set<EdgeId>& prohibitedEdges);

} // namespace maps::mrc::gen_targets
