#pragma once

#include "data_model.h"

#include <pqxx/transaction_base>

namespace maps::mrc::gen_targets {

const int NO_SUBDISTRICTS_DEPTH = -1;

class YmapsdfDataLoader {
public:
    YmapsdfDataLoader(
        pqxx::transaction_base& txn)
    : txn_(txn)
    {}

    MultiDistrict loadAdDistrict(Id adId);

    // @brief recursively loads child districts by parent district Id.
    // Returns only the hierarchically lowest districts with the
    // provided levelKind which don't have subdistricts
    // with levelKind <= provided level kind.
    std::vector<MultiDistrict> loadAdSubdistricts(
        AdId parentAdId, int levelKind, int depth = NO_SUBDISTRICTS_DEPTH);

private:
    pqxx::transaction_base& txn_;
};

} // namespace maps::mrc::gen_targets
