#include "geobase.h"

#include <maps/wikimap/mapspro/services/mrc/libs/geobase/include/geobase.h>

namespace maps::mrc::taxi_stat {

namespace {

class GeobaseEvaluator : public GeoEvaluator {
public:
    GeobaseEvaluator(NYT::IClientPtr ytClient,
                     const std::string& geodataPath,
                     const std::string& geodataPatchYtDir)
        : geobasePtr_(geobase::loadPatchedGeobasePtr(
              ytClient,
              geodataPatchYtDir,
              std::make_unique<geobase::Geobase6Adapter>(geodataPath)))
    {
    }

    GeoIds evalGeoIds(const geolib3::Point2& geodeticPos) const override
    {
        auto result = GeoIds{};
        auto geoId = geobasePtr_->getRegionIdByLocation(geodeticPos);
        if (regionFilter(geoId)) {
            result.push_back(geoId);
        }
        for (auto parentGeoId : geobasePtr_->getRegionParentIds(geoId)) {
            if (regionFilter(parentGeoId)) {
                result.push_back(parentGeoId);
            }
        }
        return result;
    }

private:
    geobase::GeobasePtr geobasePtr_;

    bool regionFilter(GeoId geoId) const
    {
        auto region = geobasePtr_->getRegionById(geoId);
        // @see
        // https://doc.yandex-team.ru/lib/libgeobase5/concepts/region-types.html
        constexpr GeoId REGION_TYPE_COUNTRY = 3;
        constexpr GeoId REGION_TYPE_CITY = 6;
        return REGION_TYPE_COUNTRY <= region.type &&
               region.type <= REGION_TYPE_CITY;
    };
};

}  // namespace

GeoEvaluatorPtr makeGeobaseEvaluator(NYT::IClientPtr ytClient,
                                     const std::string& geodataPath,
                                     const std::string& geodataPatchYtDir)
{
    return std::make_shared<GeobaseEvaluator>(
        ytClient, geodataPath, geodataPatchYtDir);
}

}  // namespace maps::mrc::taxi_stat
