#pragma once

#include "utility.h"

#include <mapreduce/yt/interface/client.h>
#include <maps/libs/geolib/include/point.h>

namespace maps::mrc::taxi_stat {

struct GeoEvaluator {
    virtual ~GeoEvaluator() = default;
    virtual GeoIds evalGeoIds(const geolib3::Point2& geodeticPos) const = 0;
};

using GeoEvaluatorPtr = std::shared_ptr<GeoEvaluator>;

GeoEvaluatorPtr makeGeobaseEvaluator(NYT::IClientPtr,
                                     const std::string& geodataPath,
                                     const std::string& geodataPatchYtDir);

}  // namespace maps::mrc::taxi_stat
