#pragma once

#include "geobase.h"

#include <mapreduce/yt/interface/client.h>

namespace maps::mrc::taxi_stat {

namespace log {
const TString DATE = "date";
const TString GEO_ID = "geo_id";
const TString BYTES_NUMBER = "bytes_number";
const TString MAX_EVENT_ID = "max_event_id";
const TString DEVICE_IDS = "device_ids";
}  // namespace log

namespace events {
const TString ID = "id";
const TString CREATED_AT = "created_at";
const TString GNSS_LONGITUDE = "gnss_longitude";
const TString GNSS_LATITUDE = "gnss_latitude";
const TString EVENT_TYPE = "event_type";
const TString PRESIGNED_EXTERNAL_VIDEO_URL = "presigned_external_video_url";
const TString DEVICE_ID = "device_id";
}  // namespace events

namespace bans {
const TString DATE = "date";
const TString DISQ_TYPE = "disq_type";
const TString COUNT = "count";
}  // namespace bans

namespace activity {
const TString DATE = "date";
const TString GEO_ID = "geo_id";
const TString COUNT = "count";
}  // namespace activity

namespace logfeller {
const TString REQUEST = "request";
const TString TIMESTAMP = "timestamp";
const TString USER_AGENT = "user_agent";
const TString VHOST = "vhost";
}  // namespace logfeller

const EventId PREVIOUS_OF_FIRST_EVENT_ID = 85'000'000;

const TString AGENT_PROXY_HOST = "core-nmaps-mrc-agent-proxy.maps.yandex.net";
const TString TAXI_REQUEST_PATH = "/ugc/targets/tiles";
const TString TAXI_USER_AGENT = "mrc-taxi-signalq2";

void grepEvents(NYT::ITransaction&,
                std::string_view inputTable,
                std::string_view outputTable,
                EventId startEventId);

void loadEvents(NYT::ITransaction&,
                GeoEvaluator&,
                std::string_view eventsTable,
                Log& result);

Log loadLog(NYT::ITransaction&, std::string_view logTable);

void saveLog(NYT::ITransaction&, const Log&, std::string_view outputTable);

void saveBans(NYT::ITransaction&, const Bans&, std::string_view outputTable);

/// @p inputDir - //home/logfeller/logs/maps-log/1d
/// @p outputTable - //home/maps/core/mrc/production/taxi_tile_requests
void grepTileRequestsFromDir(NYT::ITransaction&,
                             std::string_view inputDir,
                             std::string_view outputTable,
                             std::optional<chrono::TimePoint> startDate);

/// @p tileRequestsTable - //home/maps/core/mrc/production/taxi_tile_requests
void loadTileRequests(NYT::ITransaction&,
                      GeoEvaluator&,
                      std::string_view tileRequestsTable,
                      Activity& result);

/// @p activityTable - //home/maps/core/mrc/production/taxi_activity
Activity loadActivity(NYT::ITransaction&, std::string_view activityTable);

/// @p outputTable - //home/maps/core/mrc/production/taxi_activity
void saveActivity(NYT::ITransaction&,
                  const Activity&,
                  std::string_view outputTable);

}  // namespace maps::mrc::taxi_stat
