#include <maps/wikimap/mapspro/services/mrc/long_tasks/toloka_manager_cron_jobs/lib/include/house_number_recognition.h>

#include <util/charset/utf8.h>
#include <util/charset/wide.h>

namespace maps {
namespace mrc {
namespace toloka {

std::string normalizeSymbolsInString(const std::string& str)
{
    static const std::map<char16_t, char16_t> symbolNormalizeMap = {
        { 1040,   65 }, // А
        { 1042,   66 }, // В
        { 1045,   69 }, // Е
        { 1047,   51 }, // З
        { 1050,   75 }, // К
        { 1052,   77 }, // М
        { 1053,   72 }, // Н
        { 1054,   79 }, // О
        { 1056,   80 }, // Р
        { 1057,   67 }, // С
        { 1058,   84 }, // Т
        { 1059,   89 }, // У
        { 1061,   88 }, // Х
    };

    TUtf16String wideStr = UTF8ToWide(str);

    std::locale loc("en_US.utf8");
    TUtf16String result;
    for (size_t chIdx = 0; chIdx < wideStr.size(); chIdx++) {
        char16_t ch = std::toupper((wchar_t)wideStr[chIdx], loc);
        auto it = symbolNormalizeMap.find(ch);
        if (it != symbolNormalizeMap.end()) {
           ch = it->second;
        }

        result += ch;
    }

    return WideToUTF8(result);
}

HouseNumberRecognition::TaskOutput HouseNumberRecognition::mergeSingleTaskResults(
    const HouseNumberRecognition::AssignmentResults& results,
    size_t taskIdx)
{
    std::vector<std::string> numbers;
    for (const auto& res : results) {
        numbers.push_back(res.outputs[taskIdx].houseNumber());
    }

    std::sort(numbers.begin(), numbers.end());
    const auto pair = longestEqualRange(numbers.begin(), numbers.end());
    if ((size_t)std::distance(pair.first, pair.second) <= numbers.size() / 2) {
        return HouseNumberRecognition::TaskOutput{
            HouseNumberRecognition::TaskAnswer::NotRecognized, ""
        };
    }

    if (pair.first->empty()) {
        return HouseNumberRecognition::TaskOutput{
            HouseNumberRecognition::TaskAnswer::NotRecognized, ""
        };
    } else {
        return HouseNumberRecognition::TaskOutput{
            HouseNumberRecognition::TaskAnswer::Ok, *pair.first
        };

    }
}

HouseNumberRecognition::TaskSuiteResult HouseNumberRecognition::mergeTaskSuiteResults(
    const HouseNumberRecognition::AssignmentResults& assignmentResults)
{
    HouseNumberRecognition::TaskSuiteResult tsResult;

    REQUIRE(!assignmentResults.empty(), "Empty task suite results");
    size_t tasksCount = assignmentResults[0].inputs.size();

    for (size_t i = 0; i < tasksCount; ++i) {
        HouseNumberRecognition::TaskInput input = assignmentResults[0].inputs[i];
        HouseNumberRecognition::TaskOutput output = mergeSingleTaskResults(assignmentResults, i);

        tsResult.taskResults.push_back({input, output});
    }

    return tsResult;
}

void HouseNumberRecognition::evaluateAssignments(
    const io::TolokaClient& /*tolokaClient*/,
    const HouseNumberRecognition::TaskSuiteResult& /*tsResult*/)
{
    return;
}

} // toloka
} // mrc
} // maps
